#ifndef LCD_H //LCD_H
#define LCD_H //LCD_H

#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/spi.h"
#include "hardware/pwm.h"

#include "Arial_round_16x24.c"

// for PICO
#define SPI_PORT spi0
#define LCDCS (12)
#define LCDRST (13)
#define LCDDC (14)
#define TOUCHCS (15)
#define MISOPIN (16)
#define TOUCHIRQ (17)
#define SCKPIN (18)
#define MOSIPIN (19)
#define BLPIN (20)
#define SDCS (21)

//colours are 24bit/18bit, BGR
#define BLACK 0x000000l
#define RED 0x0000FFl
#define BLUE 0xFF0000l
#define GREEN 0x00FF00l
#define YELLOW 0x00FFFFl
#define MAGENTA 0xFF00FFl
#define CYAN 0xFFFF00l  
#define WHITE 0xFFFFFFl
#define GREY 0x808080l

#define BUTTON_FONT Arial_round_16x24
#define BUTTON_IDLE_TEXT WHITE
#define BUTTON_IDLE_BACK BLACK
#define BUTTON_IDLE_BORDER GREY
#define BUTTON_PRESS_TEXT BLACK
#define BUTTON_PRESS_BACK WHITE
#define BUTTON_PRESS_BORDER GREY
#define BUTTON_BACKGROUND BLACK
#define BUTTON_NO_CHANGE (0)
#define BUTTON_DOWN (1)
#define BUTTON_UP (2)

#define LCD_SPEED (50000000L)
//#define LCD_SPEED (1000000L)
#define TOUCH_SPEED (1000000L)
#define Z_TOUCH_THRESHOLD 20
#define TOUCH_X0 110
#define TOUCH_X1 2001
#define TOUCH_Y0 1993
#define TOUCH_Y1 76
#define TOUCH_OVERSAMPLE 16

#define BL_MAX 100

//global status/info
extern int width,height,rotation;

//button object
typedef struct{
  int x;
  int y;
  int w;
  int h;
  const char* text;
  char pressed;
  char visible;
  char lastchange;	//=0
} button;

void setbacklight(int b);
void displaySetup();
void setrotation(char r);
void setarea(int x0,int y0,int x1,int y1);
void clear(unsigned long c);
void point(int x, int y, unsigned long c);
void data8(char d);
unsigned int data16(unsigned char d);
void data24(unsigned int d);		//writes 3 prepared bytes in native machine order for speed
void cmd8(char d);
unsigned int touchraw(unsigned char r);
int touchx();
int touchy();
int showchar(int x0,int y0,char c,const unsigned char* font, unsigned long f, unsigned long b);
int showarray(int x0,int y0,const char* c,const unsigned char* font, unsigned long f, unsigned long b);
int fontwidth(const unsigned char* font);
int fontheight(const unsigned char* font);
int arraywidth(const char* c,const unsigned char* font);
void box(int x0,int y0,int x1,int y1, unsigned long c);
void line(int x1,int y1,int x2,int y2, unsigned long c);
void hline(int x1,int y1,int x2,unsigned long c);
void vline(int x1,int y1,int y2,unsigned long c);
void fcircle(int xo,int yo,int r,unsigned long c);
void circle(int xo,int yo,int r,unsigned long c);
void textbox(int x0,int y0, int w, int h, const char* c,const unsigned char* font, unsigned long tc, unsigned long bc, unsigned long bordc);
int checkpress(button* b);
void drawbutton(button* b);

#endif  //LCD_H
